{ ------------------------------------------------------------------------ }
{  @@ Usage                                                                }
{                                                                          }
{   function HeapFunc (Size: Word): Integer; far;                          }
{                                                                          }
{   DESCRIPTION:                                                           }
{       Heap error function. It gets called whenever GetMem() fails.       }
{       When GetMem() fails, this function returns 1 which causes          }
{       GetMem() to return nil.                                            }
{                                                                          }
{       It is used to avoid run-time error when memory allocation fails.   }
{                                                                          }
{   ENTRY:                                                                 }
{       Size :- This is the size of memory requested but could not be      }
{               allocated.                                                 }
{                                                                          }
{   EXIT:                                                                  }
{       returns 1 when GetMem() fails.                                     }
{                                                                          }
{ ------------------------------------------------------------------------ }

function HeapFunc(Size: Word): Integer; far;
begin
    { if Size is 0, the return value will be ignored }
    if Size > 0 then
        HeapFunc := 1;
end;



{ ------------------------------------------------------------------------ }
{  @@ Usage                                                                }
{                                                                          }
{   function LoadDriver (szDrvName : string) : pointer                     }
{                                                                          }
{   DESCRIPTION:                                                           }
{       Loads driver into memory with the driver name specified. Upon      }
{       return, the return pointer is pointed to the driver memory.        }
{       The pointer is always adjusted to offset 0 to conform with the     }
{       driver requirement. All the loadable drivers must be loaded to     }
{       offset 0 of a segment.                                             }
{                                                                          }
{       The heap manager is used to check the status of memory allocation  }
{       to avoid run-time error when memory allocation fails.              }
{                                                                          }
{   ENTRY:                                                                 }
{       szDrvName :- Driver name to be loaded.                             }
{                                                                          }
{   EXIT:                                                                  }
{       Pointer to the loaded driver.                                      }
{                                                                          }
{ ------------------------------------------------------------------------ }

function LoadDriver (szDrvName : string) : pointer;
type
    PtrRec = record
        lo, hi : word
    end;

var
    wTemp, wDrvSize: word;
    lpPtr : pointer;
    F : file;
    szDrvFile : string;
    sDrvInfo : SearchRec;

begin
    { Install HeapError function }
    HeapError := @HeapFunc;

    LoadDriver := nil;

    szDrvFile := GetEnv('SOUND');

    { search SOUND environment for driver }
    if szDrvFile <> '' then begin
        szDrvFile := szDrvFile + '\DRV\' + szDrvName;
        FindFirst(szDrvFile, Archive, sDrvInfo);
    end;

    { not found, search current directory for driver }
    if DosError <> 0 then begin
        szDrvFile := szDrvName;
        FindFirst(szDrvFile, Archive, sDrvInfo);
    end;

    if DosError = 0 then begin
        {$I-}
        Assign(F, szDrvFile);
        Reset(F,1);
        {$I+}

        if IOResult = 0 then begin
            wDrvSize := word(FileSize(F));

            { allocate memory for driver + 15 bytes more for boundary adjust }
            GetMem(lpPtr, wDrvSize + 15);

            { If successfully allocated memory }
            if lpPtr <> nil then begin

                { boundary adjust as driver need to be loaded at offset 0 }
                wTemp := PtrRec(lpPtr).hi + ((PtrRec(lpPtr).lo + 15) shr 4);
                lpPtr := pointer(Longint(wTemp) shl 16);

                LoadDriver := lpPtr;
                BlockRead(F,lpPtr^,wDrvSize,wTemp);

                if wDrvSize <> wTemp then begin
                    LoadDriver := nil;
                    writeln('Read file error ...');
                end;
            end
            else
                writeln('Memory allocation error ...');

            close(F);
        end
        else
            writeln('Could not open ',szDrvName,'...');

    end
    else
        writeln('Driver file ',szDrvName,' does not exist ...');
end;

